#!/bin/sh

# turn on ipmi driver and start it
chkconfig ipmi on
service ipmi start

# Restore before making changes
iptables-restore < /etc/sysconfig/iptables

PORTENABLED=`iptables -L -n | grep 161`
if [ "$PORTENABLED" = "" ]; then 
  iptables -I INPUT 1 -p udp --dport 161 -j ACCEPT
fi

PORTENABLED=`iptables -L -n | grep 162`
if [ "$PORTENABLED" = "" ]; then 
  iptables -I OUTPUT 1 -p udp --sport 162 -j ACCEPT
fi

PORTENABLED=`iptables -L -n | grep 280`
if [ "$PORTENABLED" = "" ]; then 
  iptables -I OUTPUT 1 -p tcp --sport 280 -j ACCEPT
fi

PORTENABLED=`iptables -L -n | grep 2301`
if [ "$PORTENABLED" = "" ]; then 
  iptables -I INPUT 1 -p tcp --dport 2301 -j ACCEPT
fi

PORTENABLED=`iptables -L -n | grep 2381`
if [ "$PORTENABLED" = "" ]; then 
  iptables -I INPUT 1 -p tcp --dport 2381 -j ACCEPT
fi

iptables-save > /etc/sysconfig/iptables

mv /opt/hp/hp-agents-xs/hp-snmp-agents.conf /etc/
source /etc/hp-snmp-agents.conf

if [ -x /sbin/hpsnmpconfig ]; then
  echo Activating HP Agents...
  /sbin/hpsnmpconfig 
  #service hp-ilo restart
  service hp-health restart
  service hp-snmp-agents restart
  service hpsmhd restart
fi

if [ "$?" == 0 ]; then
  echo "Configuration Complete!"
  exit 0
fi
