<?php

// this code extracts the properties for the webapp
// from the header information passed in via the environment

// it gets the webapp name from a variable named $webapp
// that needs to be defined before this file is included/required
// AND webapp needs to be all upper case

$webapp_properties = array();   // initialize the properties to an empty array
$accessLevel = 0;

class webapp_property {
    var $readval = false;
    var $writeval = false;
	
    function webapp_property($valuein = 0) {
        $this->readval = ($valuein / 10) > 0;
        $this->writeval = ($valuein % 10) > 0;
    }

    function read() { return $this->readval; }
    function write() { return $this->writeval; }
}


if( isset( $webapp ))
{
    // the webapp variable exists, look for properties
    $upperwebapp = strtoupper($webapp);
    $headervar = "HTTP_{$upperwebapp}_PROP";

    //echo "Looking for $headervar in the environment<br>\n";

    if( isset( $_SERVER[ $headervar ]))
    {
        //echo "Found it, value is ", $_SERVER[ $headervar ], "<br>\n";

        $propstrings = explode( ';', $_SERVER[ $headervar ]);

        foreach ($propstrings as $proppair)
        {
            $splitstring = explode( ':', $proppair );

            if( 2 != count( $splitstring ))
            {
                //echo "$proppair split into too many items (", count($splitstring), ")<br>\n";
            }
            else
            {
                //--- put it in the properties array

                $webapp_properties[ $splitstring[0] ] = new webapp_property( $splitstring[1] );

                //echo "Adding property ", $splitstring[0], " with value ", $splitstring[1], "<br>\n";
            }
        }
    }
    else
    {
        //echo "Not found<br>\n";
    }
}

function VerifyAccessLevel()
{
	global $webapp_properties;
	global $accessLevel;
        
        
	if($webapp_properties["SNMPConfigHigh"]->readval == 1 &&
	   $webapp_properties["SNMPConfigHigh"]->writeval == 1)
        { 
   		print "\n var cpqSNMPCFGAccess = 3;";  //administrator
		$accessLevel = 3;
	}


	else if ($webapp_properties["SNMPConfigMedium"]->readval == 1 &&
		   $webapp_properties["SNMPConfigMedium"]->writeval == 1)
	{
	    print "\n var cpqSNMPCFGAccess = 2;";  //operator
		$accessLevel = 2;
	}

	else
	{
		print "\n var cpqSNMPCFGAccess = 1;";  //user or anonymous
		$accessLevel = 1;
	}

}

?>
