/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * PanelManager is an abstract base class. This class have some methods used by 
 * application to resize panels.
 * 
 * @constructor
 * @author		Gilson Hoffmeister
 * @required	LayoutManager
 */
function PanelManager() {
	if (typeof(LayoutManager)!= "undefined") {
		layoutManager = new LayoutManager();
		layoutManager.showContent();
	}
	this.windowWidth = layoutManager.getWindowWidth();
	this.windowHeight = layoutManager.getWindowHeight();

	this.border = 5;
	this.gutter = 7;
	this.margin = 14;
	this.scroll = 18;

	this.headerHeight = 39;
	this.menuHeight = 23;
	this.titleHeight = 60;
	
	this.statusIcon = 178; // 178 width, 10 margin left and 2 x 1px border

	this.panelWidth = 0;
	this.panelHeight = 0;
}

/**
 * Set Content panel functionalities.
 */
PanelManager.prototype.setContent = function() {
	this.panelWidth = this.windowWidth - (this.border * 2) - (this.gutter * 2);
	this.panelHeight = this.windowHeight - this.headerHeight - this.menuHeight - this.titleHeight - this.border - (this.gutter * 2);

	var content = document.getElementById("iframeContent");
	if (content != null) {
		layoutManager.setSize(content, this.panelWidth, this.panelHeight);
		layoutManager.changeDisplay("iframeContent", "show");
		//content.contentWindow.location.reload(true);
	}
};

/**
 * Set Boxes functionalities.
 *
 * @param	{Number}	boxNumber	Number of the boxes per line.
 */
PanelManager.prototype.setBoxes = function(boxNumber) {
	if (this.windowWidth != 0) {
		if (isInternetExplorer()) {
			this.panelWidth = Math.round((this.windowWidth - this.margin) / boxNumber) - this.margin;
		}
		else {
			this.panelWidth = Math.round((this.windowWidth - this.margin - this.scroll) / boxNumber) - this.margin;
		}
		var divCollection = document.getElementsByTagName("div");
		for (var i = 0; i < divCollection.length; i++) {
			if (divCollection[i].className == "box") {
				layoutManager.setWidth(divCollection[i], this.panelWidth+3);
			
				var itemCollection = divCollection[i].getElementsByTagName("li"); 
				for (var j = 0; j < itemCollection.length; j++) {
					var link = itemCollection[j].getElementsByTagName("a")[0];
					layoutManager.setWidth(link, this.panelWidth - 42);
				}
			}
		}
	}
}

/**
 * Set System Status Summary box functionalities.
 */
PanelManager.prototype.setSystemStatusSummary = function() {
	var systemStatusSummary = document.getElementById("systemStatusSummary");
	
	if (this.windowWidth != 0 && systemStatusSummary != null) {
        	if (isInternetExplorer()) {
			this.panelWidth = this.windowWidth - (this.margin * 2) - this.statusIcon;
		}
		else {
			this.panelWidth = this.windowWidth - (this.margin * 2) - this.scroll - this.statusIcon;
		}
		layoutManager.setWidth(systemStatusSummary, this.panelWidth);
	}
}
