/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * LayoutManager is an abstract base class. This class have some methods for 
 * using in page layout.
 * 
 * @constructor
 * @author	Gilson Hoffmeister
 */
function LayoutManager() {
	// Constructor
}

/**
 * Get the window width size.
 *
 * @return	{Number}	The current browser window width size.
 */
LayoutManager.prototype.getWindowWidth = function() {
	var windowWidth = 0;
	if (typeof(window.innerWidth) == "number") {
		windowWidth = window.innerWidth;
	}
	else {
		if (document.documentElement && document.documentElement.clientWidth) {
			windowWidth = document.documentElement.clientWidth;
		}
		else {
			if (document.body && document.body.clientWidth) {
				windowWidth = document.body.clientWidth;
			}
		}
	}
	return windowWidth;
};

/**
 * Get the window height size.
 *
 * @return	{Number}	The current browser window height size.
 */
LayoutManager.prototype.getWindowHeight = function() {
	var windowHeight = 0;
	if (typeof(window.innerHeight) == "number") {
		windowHeight = window.innerHeight;
	}
	else {
		if (document.documentElement && document.documentElement.clientHeight) {
			windowHeight = document.documentElement.clientHeight;
		}
		else {
			if (document.body && document.body.clientHeight) {
				windowHeight = document.body.clientHeight;
			}
		}
	}
	return windowHeight;
};

/**
 * Remove a class to element.
 * 
 * @param	{Object}	element		Element to remove a class.
 * @param	{String}	className	Class name.
 */
LayoutManager.prototype.removeClassName = function(element, className) {
	element.className = element.className.replace(className, "").trim();
};

/**
 * Add a class to element.
 * 
 * @param	{Object}	element		Element to receive a class.
 * @param	{String}	className	Class name.
 */
LayoutManager.prototype.addClassName = function(element, className) {
	this.removeClassName(element, className);
	element.className = (element.className + " " + className).trim();
};

/**
 * Get X position of element.
 * 
 * @param	{Object}	element	Element to get x position.
 * @return	{Number}	X position of element.
 */
LayoutManager.prototype.getPosX = function(element) {
	var curleft = 0;
	if (element.offsetParent) {
		while (element.offsetParent) {
			curleft += element.offsetLeft;
			element = element.offsetParent;
		}
	}
	else if (element.x) {
		curleft += element.x;
	}
	if (navigator.userAgent.indexOf("MSIE") != -1) {
		return curleft + 5;
	}
	else {
		return curleft;
	}
};

/**
 * Get Y position of element.
 *
 * @param element
 * 			element to get Y position.
 * @return Y position of element.
 */

/**
 * Get Y position of element.
 * 
 * @param	{Object}	element	Element to get y position.
 * @return	{Number}	Y position of element.
 */
LayoutManager.prototype.getPosY = function(element) {
	var curtop = 0;
	if (element.offsetParent) {
		while (element.offsetParent) {
			curtop += element.offsetTop;
			element = element.offsetParent;
		}
	}
	else if (element.y) {
		curtop += element.y;
	}
	if (navigator.userAgent.indexOf("MSIE") != -1) {
		return curtop + 7;
	}
	else {
		return curtop;
	}
};

/**
 * Set element width.
 * 
 * @param	{Object}	element	Element to set width.
 * @param	{Number}	width	Width value.
 */
LayoutManager.prototype.setWidth = function(element, width) {
 	element.style.width = width + "px";
};

/**
 * Set element height.
 * 
 * @param	{Object}	element	Element to set height.
 * @param	{Number}	height	Height value.
 */
LayoutManager.prototype.setHeight = function(element, height) {
 	element.style.height = height + "px";
};

/**
 * Set element size.
 * 
 * @param	{Object}	element	Element to set size.
 * @param	{Number}	width	Width value.
 * @param	{Number}	height	Height value.
 */
LayoutManager.prototype.setSize = function(element, width, height) {
 	element.style.width = width + "px";
 	element.style.height = height + "px";
};

/**
 * Set element X position.
 * 
 * @param	{Object}	element	Element to set X position.
 * @param 	{Number}	x		X position value.
 */
LayoutManager.prototype.setX = function(element, x) {
 	element.style.left = x + "px";
};

/**
 * Set element Y position.
 * 
 * @param	{Object}	element	Element to set Y position.
 * @param 	{Number}	y		Y position value.
 */
LayoutManager.prototype.setY = function(element, y) {
 	element.style.top = y + "px";
};

/**
 * Set element position.
 * 
 * @param	{Object}	element	Element to set position.
 * @param	{Number}	x		X position value.
 * @param	{Number}	y		Y position value.
 */
LayoutManager.prototype.setPosition = function(element, x, y) {
 	element.style.left = x + "px";
 	element.style.top = y + "px";
};

/**
 * Get specific element style property value.
 * 
 * @param	{Object}	element		Element to get style property value.
 * @param	{String}	styleProp	Style property to get value.
 * @return	{String}	Style property value.
 */
LayoutManager.prototype.getStyle = function(element, styleProp) {
	var style = null;
	if (element.currentStyle) {
		style = element.currentStyle[styleProp];
	}
	else if (window.getComputedStyle) {
		style = document.defaultView.getComputedStyle(element, null).getPropertyValue(styleProp);
	}
	return style;
};

/**
 * Get selected checkboxes in a collection.
 * 
 * @param	{String}	checkboxCollectionName	Name of checkbox collection.
 * @return	{Object}	Array with id attibute of selected checkboxes.
 */
LayoutManager.prototype.getCheckboxesSelectedId = function(checkboxCollectionName) {
	var checkboxCollection = document.getElementsByName(checkboxCollectionName);
	var checkboxesSelected = [];
	for (var i = 0; i < checkboxCollection.length; i++) {
		if (checkboxCollection[i].checked == true) {
			checkboxesSelected.push(checkboxCollection[i].getAttribute("id"));
		}
	}
	return checkboxesSelected;
};

/**
 * Change elements display according parameters passed (name, show/hide).
 */
LayoutManager.prototype.changeDisplay = function() {
	var i;
	var display;
	var element;
	var args = this.changeDisplay.arguments;
	for (i = 0; i < (args.length - 1); i += 2) {
		if ((element = document.getElementById(args[i])) != null) {
			display = args[i + 1];
			switch(display) {
				case "show":
					element.style.display = "block";
					break;
				case "hide":
					element.style.display = "none";
					break;
				case "enable":
					element.disabled = false;
					break;
				case "disable":
					element.disabled = true;
					break;
				default:
					break;
			}
		}	
	}
};

/**
 * Get the label tag for the specified element.
 */
LayoutManager.prototype.getLabelFor = function(element) {
    var labelCollection = document.getElementsByTagName("LABEL");
    
    for (var i = 0; i < labelCollection.length; i++) {
        if (labelCollection[i].htmlFor == element.id) {
            return labelCollection[i];
        }
    }
    
    return null;
};

/**
 * Hide loading box and show content box.
 */
LayoutManager.prototype.showContent = function() {
	//this.changeDisplay("loadingBox", "hide", "loadingContent", "show");
};