/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * FormManager is an abstract base class. This class have some methods for 
 * using in forms.
 * 
 * @constructor
 * @author	Gilson Hoffmeister
 * @see		LayoutManager
 */
function FormManager() {
	this.mainForm = document.getElementById("main");
	this.applicationPath = null;
}

/**
 * Focus specified element in a form.
 * 
 * @param	{Object}	element	Element name that will be focused.
 */
FormManager.prototype.focus = function(element) {
	element.focus();
	element.select();
};

/**
 * Get application path.
 * 
 * @return	{String}	The application path.
 */
FormManager.prototype.getApplicationPath = function() {
	return this.applicationPath;
}

/**
 * Get radio group value.
 * 
 * @param	{Object}	element	Array with radio group elements.
 * @return	{String}	Radio group value.
 */
FormManager.prototype.getRadioGroupValue = function(element) {
	var result = -1;
	for (var i = 0; i < element.length; i++) {
		if(element[i].checked) {
			result = element[i].value;
			break;
		}
	}
	return result;
};

/**
 * Performs form action specified.
 * 
 * @param	{String}	action	Form action to be execute.
 */
FormManager.prototype.performAction = function(action) {
	this.mainForm.action = this.getApplicationPath() + action + ".do";
	this.mainForm.submit();
};