/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * PanelManager is an abstract base class. This class have some methods used by 
 * application index to resize panels.
 * 
 * @constructor
 * @author		Gilson Hoffmeister
 * @required	LayoutManager
 * @required	PanelManager
 */
function BoxManager() {
	this.boxNumber = columnNumberLimit;
	this.lineNumber = 5;
	this.lineHeight = 24;
}

/**
 * Adjust width of all boxes.
 */
BoxManager.prototype.initialize = function() {
	if (typeof(PanelManager) != "undefined") {
		panelManager = new PanelManager();
	}
	panelManager.setBoxes(this.boxNumber);
	panelManager.setSystemStatusSummary();
};

/**
 * Show hidden items in a box.
 *
 * @param	{Object}	showAllLink		Link to show all items.
 */
BoxManager.prototype.showAll = function(showAllLink) {
	var showAllBar = showAllLink.parentNode;
	var hideItemsBar = showAllLink.parentNode.parentNode.getElementsByTagName("p")[1];
	var box = showAllLink.parentNode.parentNode.parentNode;
	var boxList = box.getElementsByTagName("div")[0];
	var boxLine = box.parentNode;
	
	// Change display action bar
	showAllBar.className = "hidden";
	hideItemsBar.className = "";
	
	// Show all hidden items
	var liCollection = boxList.getElementsByTagName("li");
	for (var i = 0; i < liCollection.length; i++) {
		if (liCollection[i].className.indexOf("hidden") != -1) {
			layoutManager.removeClassName(liCollection[i], "hidden");
		}
	}
	
	// Adjust height of all boxes in line
	/*var divCollection = boxLine.getElementsByTagName("div");
	for (var i = 0; i < divCollection.length; i++) {
		if (divCollection[i].className == "list") {
			var boxHeight = liCollection.length * (this.lineHeight) + 2;
			layoutManager.setHeight(divCollection[i], boxHeight);
		}
	}*/
};

/**
 * Show hidden items in a box.
 *
 * @param	{Object}	hideItemsLink		Link to hide items.
 */
BoxManager.prototype.hideItems = function(hideItemsLink) {
	var showAllBar = hideItemsLink.parentNode.parentNode.getElementsByTagName("p")[0];
	var hideItemsBar = hideItemsLink.parentNode;
	var box = hideItemsLink.parentNode.parentNode.parentNode;
	var boxList = box.getElementsByTagName("div")[0];
	var boxLine = box.parentNode;
	
	// Change display action bar
	showAllBar.className = "";
	hideItemsBar.className = "hidden";
	
	// Hide items
	var liCollection = boxList.getElementsByTagName("li");
	for (var i = this.lineNumber; i < liCollection.length; i++) {
		layoutManager.addClassName(liCollection[i], "hidden");
	}
	
	// Adjust height of all boxes in line
	/*var divCollection = boxLine.getElementsByTagName("div");
	for (var i = 0; i < divCollection.length; i++) {
		if (divCollection[i].className == "list") {
			var boxHeight = this.lineNumber * (this.lineHeight) + 2;
			layoutManager.setHeight(divCollection[i], boxHeight);
		}
	}*/
};